/*
 * Toolkit GUI, an application built for operating pinkRF's signal generators.
 *
 * Contact: https://www.pinkrf.com/contact/
 * Copyright © 2018-2024 pinkRF B.V
 * GNU General Public License version 3.
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License along with this program. If not, see https://www.gnu.org/licenses/
 *
 * Author: Iordan Svechtarov
 */

#ifndef MISCELLANEOUS_H
#define MISCELLANEOUS_H

#include <QString>
#include <QMetaType>

//Utility defines for the code
#define POWER_CONTROL_UNKNOWN		-1
#define POWER_CONTROL_NORMAL		0
#define POWER_CONTROL_ANALOG_INPUT	1
#define POWER_CONTROL_FEED_FWD		2
#define POWER_CONTROL_AMPLIFIER		3
#define POWER_CONTROL_PID			4

enum RCM_MODE : int
{
	RCM_MODE_INVALID = -1,
	RCM_MODE_OFF = 0,
	RCM_MODE_USB_LIVE = 1,
	RCM_MODE_USB_BLIND = 2,
	RCM_MODE_TCP_LIVE = 3,
	RCM_MODE_TCP_BLIND = 4,
	RCM_MODE_RS232_LIVE = 5,
	RCM_MODE_RS232_BLIND = 6,
	RCM_MODE_RS485_LIVE = 7,
	RCM_MODE_RS485_BLIND = 8,
};

#if defined (Q_OS_LINUX)

enum LED_MODE : int
{
	LED_MODE_INVALID = -1,
	LED_MODE_OFF = 0,
	LED_MODE_ON = 1,
	LED_MODE_ALARM = 2,
	LED_MODE_RCM = 3
};
Q_DECLARE_METATYPE(LED_MODE);		//Necessary for cross-thread signal and slot communication.

#endif

QString zeroChopper(QString input);
double convert_dbm_to_watt(double value_in_dBm);
double convert_watt_to_dbm(double value_in_watt);
double convert_percent_to_dB(double percent);
double convert_dB_to_percent(double dB);
double convert_multiplier_to_dB(double multiplier);
double convert_dB_to_multiplier(double dB);

bool isVersionCompatible(std::array<int,4> current, std::array<int,4> required);

#endif // MISCELLANEOUS_H
